// MathJax Configuration for Quillfy AI
window.MathJax = {
    tex: {
        inlineMath: [['$', '$'], ['\\(', '\\)']],
        displayMath: [['$$', '$$'], ['\\[', '\\]']],
        processEscapes: true,
        processEnvironments: true,
        packages: {'[+]': ['ams', 'color', 'boldsymbol']}
    },
    options: {
        skipHtmlTags: ['script', 'noscript', 'style', 'textarea', 'pre', 'code'],
        renderActions: {
            addMenu: [0, '', '']
        }
    },
    startup: {
        pageReady: () => {
            return MathJax.startup.defaultPageReady().then(() => {
                console.log('MathJax initialized for Quillfy AI');
            });
        }
    },
    svg: {
        fontCache: 'global',
        scale: 1,
        displayAlign: 'center',
        displayIndent: '0'
    }
};

// Custom function to manually typeset elements
window.typesetMath = function(element) {
    if (window.MathJax) {
        window.MathJax.typesetPromise([element]).catch((err) => {
            console.log('MathJax typeset error:', err);
        });
    }
};

// Auto-typeset new messages
document.addEventListener('DOMContentLoaded', function() {
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            mutation.addedNodes.forEach(function(node) {
                if (node.nodeType === 1 && node.classList && 
                    (node.classList.contains('message') || node.querySelector('.math-inline, .math-display'))) {
                    window.typesetMath(node);
                }
            });
        });
    });

    const chatMessages = document.querySelector('.chat-messages');
    if (chatMessages) {
        observer.observe(chatMessages, {
            childList: true,
            subtree: true
        });
    }
});